<?php
// CONFIGURE YOUR API PATHS
$GET_API = "http://localhost/react-frontend/backend/get_task.php?id=";
$UPDATE_API = "http://localhost/react-frontend/backend/update_task.php";

$id = $_GET["id"] ?? 0;

// Fetch task details
$task = null;

if ($id) {
    $json = file_get_contents($GET_API . $id);
    $response = json_decode($json, true);

    if ($response["status"] === "success") {
        $task = $response["data"];
    } else {
        die("<h3>Task not found</h3>");
    }
}

// When form submitted (Core PHP Test Mode)
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $postData = json_encode([
        "id" => $_POST["id"],
        "task_name" => $_POST["task_name"],
        "project_name" => $_POST["project_name"],
        "module" => $_POST["module"],
        "task_date" => $_POST["task_date"],
        "deadline" => $_POST["deadline"],
    ]);

    $ch = curl_init($UPDATE_API);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);

    $updateResponse = curl_exec($ch);
    curl_close($ch);

    $updateResponse = json_decode($updateResponse, true);

    $message = $updateResponse["message"] ?? "Unknown error";
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Test Edit Task (Core PHP)</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>

<body class="bg-light py-5">

<div class="container">
    <div class="card shadow-lg p-4 mx-auto" style="max-width: 600px;">
        <h3 class="mb-3 text-center">Test: Edit Task</h3>
        <hr>

        <?php if (!empty($message)) : ?>
            <div class="alert alert-info"><?= $message ?></div>
        <?php endif; ?>

        <?php if ($task) : ?>
        <form action="" method="POST">
            <input type="hidden" name="id" value="<?= $task['id'] ?>">

            <div class="mb-3">
                <label class="form-label fw-bold">Task Name</label>
                <input type="text" name="task_name" value="<?= $task['task_name'] ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Project Name</label>
                <input type="text" name="project_name" value="<?= $task['project_name'] ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Module</label>
                <input type="text" name="module" value="<?= $task['module'] ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Task Date</label>
                <input type="date" name="task_date" value="<?= $task['task_date'] ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Deadline</label>
                <input type="date" name="deadline" value="<?= $task['deadline'] ?>" class="form-control" required>
            </div>

            <button class="btn btn-primary w-100">Update Task</button>
        </form>
        <?php endif; ?>

    </div>
</div>

</body>
</html>
