<?php
session_start();
$errors = $_SESSION['errors'] ?? [];
unset($_SESSION['errors']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Add New Task</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<div class="topbar d-flex align-items-center">
    <img src="logo2.png" style="margin-right:10px;" width="35" alt="">
    <h4 class="mb-0 fw-bold">Task Management System</h4>
</div>

<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">
        <h4 class="mb-4">Add New Task</h4>

        <!-- Validation Errors -->
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php foreach ($errors as $error): ?>
                        <li><?= $error; ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="store.php" method="POST">
            <div class="row g-4">

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Date</label>
                    <input type="date" name="task_date" class="form-control form-control-lg" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project</label>
                    <select name="project_name" class="form-select form-select-lg" required>
                        <option value="">Select Project</option>
                        <option>Website Redesign</option>
                        <option>Mobile App Development</option>
                        <option>Marketing Campaign</option>
                        <option>Product Launch</option>
                        <option>Customer Onboarding</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <select name="module" class="form-select form-select-lg" required>
                        <option value="">Select Module</option>
                        <option>Development</option>
                        <option>Testing</option>
                        <option>Documentation</option>
                        <option>Code Review</option>
                        <option>Deployment</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           placeholder="Enter task name"
                           value=""
                           required>
                    
                    <!--<select name="task_name" class="form-select form-select-lg" required>-->
                    <!--    <option value="">Select Task</option>-->
                    <!--    <option>Development</option>-->
                    <!--    <option>Testing</option>-->
                    <!--    <option>Documentation</option>-->
                    <!--    <option>Code Review</option>-->
                    <!--    <option>Deployment</option>-->
                    <!--</select>-->
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Priority</label>
                    <select name="priority" class="form-select form-select-lg" required>
                        <option value="">Select Priority</option>
                        <option>High</option>
                        <option>Medium</option>
                        <option>Low</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Due Date</label>
                    <input type="date" name="deadline" class="form-control form-control-lg" required>
                </div>

            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary btn-lg px-4">
                    <i class="bi bi-check-circle"></i> Save Task
                </button>
                <a href="todo.php" class="btn btn-secondary btn-lg ms-2">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

</body>
</html>
