<?php
require_once "config/db.php";

if (!isset($_GET['id'])) {
    die("Task ID missing");
}

$id = (int) $_GET['id'];

$sql = mysqli_prepare($conn, "SELECT * FROM tasks WHERE id = ?");
mysqli_stmt_bind_param($sql, "i", $id);
mysqli_stmt_execute($sql);
$result = mysqli_stmt_get_result($sql);

if (mysqli_num_rows($result) == 0) {
    die("Task not found");
}

$todo = mysqli_fetch_assoc($result);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Task</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: #f4f6f9;
            font-family: Inter, sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center">
    <img src="logo2.png" style="margin-right:10px;" width="35">
    <h4 class="mb-0 fw-bold">Task Management System</h4>
</div>

<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">
        <h4 class="mb-4">Edit Task</h4>

        <form action="update.php" method="POST">
            <input type="hidden" name="id" value="<?= $todo['id']; ?>">

            <div class="row g-4">

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Day</label>
                    <input type="date" name="task_date"
                           value="<?= $todo['task_date']; ?>"
                           class="form-control form-control-lg" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project</label>
                    <select name="project_name" class="form-select form-select-lg" required>
                        <?php
                        $projects = [
                            "Website Redesign",
                            "Mobile App Development",
                            "Marketing Campaign",
                            "Product Launch",
                            "Customer Onboarding"
                        ];
                        foreach ($projects as $p):
                        ?>
                            <option value="<?= $p; ?>" <?= ($todo['project_name'] == $p) ? 'selected' : ''; ?>>
                                <?= $p; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <select name="module" class="form-select form-select-lg" required>
                        <?php
                        $modules = ["Development","Testing","Documentation","Code Review","Deployment"];
                        foreach ($modules as $m):
                        ?>
                            <option value="<?= $m; ?>" <?= ($todo['module'] == $m) ? 'selected' : ''; ?>>
                                <?= $m; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           placeholder="Enter task name"
                           value="<?= $todo['task_name'] ?>"
                           required>
                    <!--<select name="task_name" class="form-select form-select-lg" required>-->
                    <!--    <?php foreach ($modules as $m): ?>-->
                    <!--        <option value="<?= $m; ?>" <?= ($todo['task_name'] == $m) ? 'selected' : ''; ?>>-->
                    <!--            <?= $m; ?>-->
                    <!--        </option>-->
                    <!--    <?php endforeach; ?>-->
                    <!--</select>-->
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Priority</label>
                    <select name="priority" class="form-select form-select-lg" required>
                        <option value="">Select Priority</option>
                        <option value="High"   <?= ($todo['priority'] === 'High') ? 'selected' : ''; ?>>High</option>
                        <option value="Medium" <?= ($todo['priority'] === 'Medium') ? 'selected' : ''; ?>>Medium</option>
                        <option value="Low"    <?= ($todo['priority'] === 'Low') ? 'selected' : ''; ?>>Low</option>
                    </select>
                </div>


                <div class="col-md-6">
                    <label class="form-label fw-semibold">Due Date</label>
                    <input type="date" name="deadline"
                           value="<?= $todo['deadline']; ?>"
                           class="form-control form-control-lg" required>
                </div>

            </div>

            <div class="mt-4">
                <button class="btn btn-primary btn-lg px-4">
                    <i class="bi bi-check-circle"></i> Update Task
                </button>

                <a href="todo.php" class="btn btn-secondary btn-lg ms-2">
                    Cancel
                </a>
            </div>

        </form>
    </div>
</div>

</body>
</html>
