<?php
session_start();
require_once "config/db.php";

$errors = [];

$task_date = $_POST['task_date'] ?? '';
$project_name = trim($_POST['project_name'] ?? '');
$module = trim($_POST['module'] ?? '');
$task_name = trim($_POST['task_name'] ?? '');
$priority = trim($_POST['priority'] ?? '');
$deadline = $_POST['deadline'] ?? '';

if (!$task_date) $errors[] = "Day is required";
if (!$project_name) $errors[] = "Project is required";
if (!$module) $errors[] = "Module is required";
if (!$task_name) $errors[] = "Task is required";
if (!$priority) $errors[] = "Priority is required";
if (!$deadline) $errors[] = "Due date is required";

if (!empty($errors)) {
    $_SESSION['errors'] = $errors;
    header("Location: add.php");
    exit;
}

$stmt = mysqli_prepare($conn,
    "INSERT INTO tasks (task_date, project_name, module, task_name, priority, deadline)
     VALUES (?, ?, ?, ?, ?, ?)"
);

mysqli_stmt_bind_param(
    $stmt,
    "ssssss",
    $task_date,
    $project_name,
    $module,
    $task_name,
    $priority,
    $deadline
);

mysqli_stmt_execute($stmt);

header("Location: todo.php");
exit;
