 <?php

 ?>

<?php
session_start();
if (empty($_SESSION['id'])) {
      header('location:/task');
}

require_once "config/db.php";

$result = mysqli_query($conn, "SELECT * FROM tasks ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Todo Management System</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
        .task-card {
            background: #fff;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        }
        .task-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .priority {
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 12px;
            color: #fff;
        }
        .priority.High { background: #dc3545; }
        .priority.Medium { background: #fd7e14; }
        .priority.Low { background: #198754; }

        .task-row {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            border-bottom: 1px dashed #ddd;
        }
        .task-row:last-child { border-bottom: none; }
        .task-actions {
            display: flex;
            gap: 10px;
            margin-top: 12px;
        }
        .btn.edit { background: #0d6efd; color:#fff; }
        .btn.delete { background: #dc3545; color:#fff; }
         .footer_section {
  position: fixed;
  width: 100%;
  background: #fff;
  bottom: 0;
  padding: 10px;
  text-align: center;
  left: 0;
  right: 0;
  margin: auto;
  border-top: 1px solid #eee;
}
.footer_section a {
  color: #003e77;
  font-size: 13px;
  text-decoration: none;
}
.footer_section td {
  width: 24.5%;
}
.add_new
{
    position: fixed;z-index: 99;right: 6px;
}
.add_new a
{
   border-radius: 50%;
  width: 51px;
  height: 51px;
  padding-top: 4px;
  font-size: 30px;
}
    </style>
</head>

<body>

<div class="topbar d-flex align-items-center">
    <img src="logo2.png" width="35">
    <h4 class="mb-0 fw-bold">Todo Management System</h4>
</div>

<div class="container py-3">
     <div class="add_new">
          <a href="add.php" class="btn btn-sm btn-primary mt-2">
            <i class="bi bi-plus-circle"></i> <br/>
        </a></div>
    
    <div class="card p-2 shadow-sm rounded-4">

        <h5 class="mb-3">Todo List</h5>

        <div class="task-list">

        <?php if (mysqli_num_rows($result) > 0): ?>
            <?php $i = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                <div class="task-card">
                    <div class="task-header">
                        <span class="fw-bold">#<?= $i++; ?></span>
                        <span class="priority <?= $row['priority']; ?>">
                            <?= $row['priority']; ?>
                        </span>
                    </div>

                    <div class="task-row">
                        <span>Date</span>
                        <strong><?= date('d-m-Y', strtotime($row['task_date'])); ?></strong>
                    </div>

                    <div class="task-row">
                        <span>Project</span>
                        <strong><?= htmlspecialchars($row['project_name']); ?></strong>
                    </div>

                    <div class="task-row">
                        <span>Module</span>
                        <strong><?= htmlspecialchars($row['module']); ?></strong>
                    </div>

                    <div class="task-row">
                        <span>Task</span>
                        <strong><?= htmlspecialchars($row['task_name']); ?></strong>
                    </div>

                    <div class="task-row">
                        <span>Due Date</span>
                        <strong><?= date('d-m-Y', strtotime($row['deadline'])); ?></strong>
                    </div>

                    <div class="task-actions">
                        <a href="edit.php?id=<?= $row['id']; ?>" class="btn edit">✏️ Edit</a>
                        <a href="delete.php?id=<?= $row['id']; ?>"
                           class="btn delete"
                           onclick="return confirm('Delete this task?')">🗑 Delete</a>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p class="text-center text-muted">No tasks found</p>
        <?php endif; ?>

        </div>

        <a href="add.php" class="btn btn-sm btn-primary mt-2">
            <i class="bi bi-plus-circle"></i> Add New
        </a>

    </div>
</div>
<div style="width:100%; height:70px;"></div>
<div class="footer_section">
    <table border="0" cellspacing="0" cellpadding="0" width="100%">
      <tbody><tr>
        <td><a href="dashboard.php"><i class="fas fa-th-large fa-fw"></i><br>
          Dashboard</a></td>
        <td><a href="#"><i class="fas fa-tasks"></i><br>
          My Task</a></td>
        <td><a href="#"><i class="fas fa-user-check"></i> <br>
          Delegated</a></td>
        <td><a href="/task/logout.php"><i class="fas fa-sign-out-alt"></i><br>
          Log Out</a></td>
      </tr>
    </tbody></table>
  </div>
</body>
</html>
