<?php

namespace App\Http\Controllers;

use App\Models\Task;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TaskController extends Controller
{
    /**
     * Display all tasks of logged-in user
     */
    // public function index()
    // {
    //     $tasks = Task::where('id', Auth::id())
    //         ->orderBy('task_date', 'desc')
    //         ->get();

    //     return view('tasks.index', compact('tasks'));
    // }

    public function index()
{
    $tasks = Task::select('id', 'task_name', 'project_name', 'module', 'task_date', 'deadline')
        // ->where('id', Auth::id())
        ->orderBy('task_date', 'desc')
        ->get();
        // dd($tasks);

    return view('tasks.index', compact('tasks'));
}


    /**
     * Show create task form
     */
    public function create()
    {
        return view('tasks.create');
    }

    /**
     * Store new task
     */
    public function store(Request $request)
    {
        $request->validate([
            'task_name'    => 'required|string|max:255',
            'project_name' => 'required|string|max:255',
            'module'       => 'required|string|max:255',
            'task_date'    => 'required|date',
            'deadline'     => 'required|date|after_or_equal:task_date',
        ]);

        Task::create([
            'id'      => Auth::id(),
            'task_name'    => $request->task_name,
            'project_name' => $request->project_name,
            'module'       => $request->module,
            'task_date'    => $request->task_date,
            'deadline'     => $request->deadline,
        ]);

        return redirect()
            ->route('tasks.index')
            ->with('success', 'Task created successfully');
    }

    /**
     * Show edit task form
     */
    
 
public function edit($id)
{
    $task = Task::select(
            'id',
            'task_name',
            'project_name',
            'module',
            'task_date',
            'deadline'
        )
        ->where('id', $id)
        // ->where('id', Auth::id()) // 🔐 security
        ->firstOrFail();               // ✅ single record

    return view('tasks.edit', compact('task'));
}



    /**
     * Update task
     */
    public function update(Request $request, Task $task)
    {
        // $this->authorizeTask($task);

        $request->validate([
            'task_name'    => 'required|string|max:255',
            'project_name' => 'required|string|max:255',
            'module'       => 'required|string|max:255',
            'task_date'    => 'required|date',
            'deadline'     => 'required|date|after_or_equal:task_date',
        ]);

        $task->update([
            'task_name'    => $request->task_name,
            'project_name' => $request->project_name,
            'module'       => $request->module,
            'task_date'    => $request->task_date,
            'deadline'     => $request->deadline,
        ]);

        return redirect()
            ->route('tasks.index')
            ->with('success', 'Task updated successfully');
    }

    /**
     * Delete task
     */
    public function destroy(Task $task)
    {
        // $this->authorizeTask($task);
        $task->delete();

        return redirect()
            ->route('tasks.index')
            ->with('success', 'Task deleted successfully');
    }

    /**
     * Ensure user owns the task
     */
    private function authorizeTask(Task $task)
    {
        if ($task->user_id !== Auth::id()) {
            abort(403, 'Unauthorized action');
        }
    }
}

