<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Todo Management System</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center">
    <img src="{{ asset('logo2.png') }}" style="margin-right:10px;" width="35" alt="">
    <h4 class="mb-0 fw-bold">Todo Management System</h4>
</div>

<!-- Body -->
<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">Todo List</h4>
            <a href="{{ route('todos.create') }}" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Add New
            </a>
        </div>

        <!-- <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Task List</h4>

    @php
        $routeName = Route::currentRouteName();
        $createRoute = $routeName === 'tasks.index'
            ? 'tasks.create'
            : ($routeName === 'todos.index' ? 'todos.create' : null);
    @endphp

    @if($createRoute)
        <a href="{{ route($createRoute) }}" class="btn btn-sm btn-primary">
            <i class="bi bi-plus-circle"></i> Add New
        </a>
    @endif
</div> -->


        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle">
                <thead class="table-primary">
                <tr>
                    <th>#</th>
                    <th>Day</th>
                    <th>Project Name</th>
                    <th>Module</th>
                    <th>Task</th>
                    <th>Priority</th>
                    <th>Due Date</th>
                    <!-- <th>Deadline</th> -->
                    <th width="120">Actions</th>
                </tr>
                </thead>
                <tbody>

                @forelse($todos as $key => $todo)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ \Carbon\Carbon::parse($todo->task_date)->format('d-m-Y') }}</td>
                        <td>{{ $todo->project_name }}</td>
                        <td>{{ $todo->module }}</td>
                        <td>{{ $todo->task_name }}</td>
                        <td>{{ $todo->priority }}</td>
                        <td>{{ \Carbon\Carbon::parse($todo->deadline)->format('d-m-Y') }}</td>
                        <td>
                            <a href="{{ route('todos.edit', $todo->id) }}"
                               class="btn btn-sm btn-primary">
                                <i class="bi bi-pencil"></i>
                            </a>

                            <form action="{{ route('todos.destroy', $todo->id) }}"
                                  method="POST"
                                  class="d-inline"
                                  onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted">
                            No tasks found
                        </td>
                    </tr>
                @endforelse

                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
