<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\TaskController;
use App\Http\Controllers\TodoController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

Route::get('/my-tasks', [TaskController::class, 'myTasks'])
    ->middleware('auth')
    ->name('my.tasks');

// Route::middleware(['auth'])->group(function () {
//     Route::get('/dashboard', [TaskController::class, 'index'])->name('dashboard');
//     Route::resource('tasks', TaskController::class);
// });

Route::middleware(['auth'])->group(function () {
    Route::resource('tasks', TaskController::class);
});

Route::middleware(['auth'])->group(function () {
    Route::resource('todos', TodoController::class);
});

require __DIR__.'/auth.php';
